import { View, Text, FlatList, TouchableWithoutFeedback, StyleSheet } from "react-native";
import React from "react";
import { useDispatch, useSelector } from "react-redux";
import { getpopularProducts } from "../../../redux/slices/popularProducts/popularProducts";
import { useEffect } from "react";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";
import { relatedItemStyle } from "../../Home/FeaturedProducts/ProductDetails/RelatedItem/relatedItemStyle";
import { filterHomeStyle } from "./FilterHomeStyle";
import { useNavigation } from "@react-navigation/native";
import ProgressiveImage from "../../../src/components/ProgressiveImage";
import { ProductsStyle } from "../../Home/FeaturedProducts/featureProductsStyle";
import PopularProductsSkeleton from "../../../src/skeletons/screens/Search/popularProductsSkeleton";
import { BASE_API_URL_STG } from "@env";
import useLangTranslation from "../../../hooks/useLangTranslation";
import gapStyle from "../../Utilities/CommonStyles/gap.style";
import { PRODUCT_DETAILS } from "../../../components/Navigation/RouteNames";

const PopularProducts = () => {
    const dispatch = useDispatch();
    const popularURL = `${BASE_API_URL_STG}/user/product-categorized/popularProducts`;
    const { trans } = useLangTranslation();
    const { popularProducts, loading } = useSelector(
        (state) => state.popularProducts
    );
    useEffect(() => {
        if(popularProducts.length == 0) {
            dispatch(getpopularProducts(popularURL));
        }
    }, []);

    const productsStyle = ProductsStyle();
    const RenderItem = ({ item }) => {
        const navigation = useNavigation();
        return (
            <View style={relatedItemStyle.imgCont}>
                <TouchableWithoutFeedback
                    onPress={() => {
                        navigation.navigate(PRODUCT_DETAILS, {
                            slug: item?.slug,
                            item
                        });
                    }}
                >
                    <View>
                        <ProgressiveImage
                            source={{ uri: item?.featured_image }}
                            style={productsStyle.img}
                        />
                    </View>
                </TouchableWithoutFeedback>
            </View>
        );
    };
    return (
        <View>
            <View style={styles.container}>
                <Text
                    style={[filterHomeStyle.header, gapStyle.mb15]}
                >
                    {trans("Most Popular")}
                </Text>
                {loading ? (
                    <View>
                        <PopularProductsSkeleton />
                    </View>
                ) : (
                    <View>
                        {popularProducts?.length > 0 ? (
                            <FlatList
                                keyboardShouldPersistTaps={"always"}
                                data={popularProducts}
                                renderItem={({ item }) => (
                                    <RenderItem item={item} />
                                )}
                                keyExtractor={(_, i) => "key" + i}
                                listKey={(_, i) => `listKey-b${i}`}
                                horizontal
                                showsHorizontalScrollIndicator={false}
                            />
                        ) : (
                            <View>
                                <Text>
                                    {trans("Popular Products List is Empty")}
                                </Text>
                            </View>
                        )}
                    </View>
                )}
            </View>
        </View>
    );
};

export default PopularProducts;

const styles = StyleSheet.create({
    container: {
        marginTop: dpr(30),
    }
});
